/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.IWSTypeEntry;
import filenet.ws.api.WSDefinedElement;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSType;
import java.util.Vector;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Node;

public class WSPart {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSPart";
    private WSDefinition m_definition = null;
    private Part m_part = null;
    private WSDefinedElement m_element = null;
    private IWSTypeEntry[] m_references = null;
    private String m_maxOccurs = null;
    private String m_minOccurs = null;
    private boolean m_isRPCPart = false;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.16  $";
    }

    public void releaseReferences() {
        block5: {
            try {
                this.m_definition = null;
                this.m_part = null;
                if (this.m_element != null) {
                    WSDefinedElement element = this.m_element;
                    this.m_element = null;
                    element.releaseReferences();
                    element = null;
                }
                if (this.m_references != null) {
                    IWSTypeEntry typeEntry = null;
                    IWSTypeEntry[] references = this.m_references;
                    for (int i = 0; i < references.length; ++i) {
                        if (references[i] == null) continue;
                        typeEntry = references[i];
                        references[i] = null;
                        typeEntry.releaseReferences();
                    }
                    this.m_references = null;
                    typeEntry = null;
                }
                this.m_maxOccurs = null;
                this.m_minOccurs = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block5;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSPart(WSDefinition definition, Part part) {
        this.m_definition = definition;
        this.m_part = part;
        String partName = part.getName();
        QName name = part.getElementName();
        boolean bl = this.m_isRPCPart = name == null;
        if (this.m_definition != null) {
            if (name != null) {
                Element e = this.m_definition.getElement(name);
                if (e != null && e instanceof DefinedElement) {
                    this.m_element = this.m_definition.getDefinedElement((DefinedElement)e);
                }
            } else {
                Vector<IWSTypeEntry> references = new Vector<IWSTypeEntry>();
                name = part.getTypeName();
                WSType type = this.m_definition.getType(name);
                Type refTypeEntry = type.getType();
                references.add(type);
                while (refTypeEntry != null) {
                    if ((refTypeEntry = refTypeEntry.getRefType()) == null) continue;
                    references.add(this.m_definition.getTypeEntry((TypeEntry)refTypeEntry));
                }
                if (references != null && references.size() > 0) {
                    this.m_references = new IWSTypeEntry[references.size()];
                    references.toArray(this.m_references);
                    references.removeAllElements();
                }
            }
        }
    }

    public String getName() {
        if (this.m_element != null) {
            return this.m_element.getName();
        }
        if (this.m_references != null && this.m_references.length > 0) {
            return this.m_part.getName();
        }
        return null;
    }

    public Part getPart() {
        return this.m_part;
    }

    public String getPartName() {
        return this.m_part.getName();
    }

    public boolean isCollection() {
        boolean bCollection = false;
        if (this.m_references != null && this.m_references.length > 0) {
            for (int i = 0; i < this.m_references.length; ++i) {
                WSDefinedElement elt;
                if (this.m_references[i] == null) continue;
                if (this.m_references[i] instanceof WSType) {
                    WSType type = (WSType)this.m_references[i];
                    if (type.isCollectionType()) {
                        return true;
                    }
                    String dimString = null;
                    dimString = type.getType().getDimensions();
                    if (dimString == null || dimString.compareTo("[]") != 0) continue;
                    this.m_maxOccurs = Utils.getAttribute((Node)type.getType().getNode(), (String)"maxOccurs");
                    this.m_minOccurs = Utils.getAttribute((Node)type.getType().getNode(), (String)"minOccurs");
                    if (this.m_maxOccurs == null) {
                        this.m_maxOccurs = "unbounded";
                    }
                    if (this.m_minOccurs == null) {
                        this.m_minOccurs = "1";
                    }
                    return true;
                }
                if (!(this.m_references[i] instanceof WSDefinedElement) || !(elt = (WSDefinedElement)this.m_references[i]).isCollectionElement()) continue;
                this.m_maxOccurs = Utils.getAttribute((Node)elt.getDefinedElement().getNode(), (String)"maxOccurs");
                this.m_minOccurs = Utils.getAttribute((Node)elt.getDefinedElement().getNode(), (String)"minOccurs");
                if (this.m_maxOccurs == null) {
                    this.m_maxOccurs = "1";
                }
                if (this.m_minOccurs == null) {
                    this.m_minOccurs = "1";
                }
                return true;
            }
        }
        return false;
    }

    public IWSTypeEntry getRefTypeEntry() {
        if (this.m_references != null && this.m_references.length > 0) {
            return this.m_references[this.m_references.length - 1];
        }
        return null;
    }

    public IWSTypeEntry[] getReferences() {
        return this.m_references;
    }

    public String getMaxOccurs() {
        if (this.m_maxOccurs == null) {
            this.isCollection();
        }
        return this.m_maxOccurs;
    }

    public String getMinOccurs() {
        if (this.m_minOccurs == null) {
            this.isCollection();
        }
        return this.m_minOccurs;
    }

    public WSDefinedElement getElement() {
        return this.m_element;
    }

    public String toString() {
        String s = new String();
        s = s + "***************** WSPart****************\n";
        s = s + "part name: " + this.m_part.getName() + "\n";
        if (this.m_references != null && this.m_references.length > 0) {
            for (int i = 0; i < this.m_references.length; ++i) {
                s = s + "m_reference[ " + i + "]: " + this.m_references[i].getName() + "\n";
            }
        }
        s = s + super.toString();
        s = s + "*****************\n";
        return s;
    }

    WSDefinition getDefinition() {
        return this.m_definition;
    }

    boolean isRPC() {
        return this.m_isRPCPart;
    }
}

